﻿using Ecng.Serialization;
using StockSharp.BusinessEntities;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace PortfolioGridLoader
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private SettingsStorage _s;
        private List<Portfolio> _pList = new List<Portfolio>();
        private int _portfolioNumber = 1;

        public MainWindow()
        {
            InitializeComponent();
        }

        private void Add_Click(object sender, System.Windows.RoutedEventArgs e)
        {
            var newPortfolio = new Portfolio() { Name = "Test_" + _portfolioNumber++, BeginValue = 1000000 };
            _pList.Add(newPortfolio);
            PortfolioGrid.Portfolios.Add(newPortfolio);
        }

        private void Remove_Click(object sender, System.Windows.RoutedEventArgs e)
        {
            PortfolioGrid.Portfolios.Remove(_pList.First());
            _pList.Remove(_pList.First());
        }

        private void Save_Click(object sender, System.Windows.RoutedEventArgs e)
        {
            _s = PortfolioGrid.Save();
        }

        private void Load_Click(object sender, System.Windows.RoutedEventArgs e)
        {
            PortfolioGrid.Load(_s);
        }
    }
}
