namespace SampleHistoryTesting
{
	using Ecng.Common;

	using StockSharp.Algo;
	using StockSharp.Algo.Candles;
	using StockSharp.Algo.Indicators;
	using StockSharp.Algo.Indicators.Trend;
	using StockSharp.Algo.Strategies;
	using StockSharp.Logging;
	using StockSharp.BusinessEntities;
using System.Collections.Generic;

	class SmaStrategy : Strategy
	{
		private readonly CandleSeries _series;
		private bool _isShortLessThenLong;

		public SmaStrategy(CandleSeries series, SimpleMovingAverage longSma, SimpleMovingAverage shortSma)
		{
			_series = series;

			LongSma = longSma;
			ShortSma = shortSma;
		}

		public SimpleMovingAverage LongSma { get; private set; }
		public SimpleMovingAverage ShortSma { get; private set; }

		protected override void OnStarted()
		{
			_series
				.WhenCandlesFinished()
				.Do(ProcessCandle)
				.Apply(this);

			//      
			_isShortLessThenLong = ShortSma.GetCurrentValue() < LongSma.GetCurrentValue();

			base.OnStarted();
		}

		private void ProcessCandle(Candle candle)
		{
			//      
			if (ProcessState == ProcessStates.Stopping)
			{
				//   
				CancelActiveOrders();
				return;
			}

			this.AddInfoLog("  {0}: {1};{2};{3};{4};  {5}".Put(candle.OpenTime, candle.OpenPrice, candle.HighPrice, candle.LowPrice, candle.ClosePrice, candle.TotalVolume));

			//   
			LongSma.Process(candle);
			ShortSma.Process(candle);

			//      
			var isShortLessThenLong = ShortSma.GetCurrentValue() < LongSma.GetCurrentValue();

			//   
			if (_isShortLessThenLong != isShortLessThenLong)
			{
				//     ,  , , .
				var direction = isShortLessThenLong ? OrderDirections.Sell : OrderDirections.Buy;

				//   (  -  )
                var order = this.CreateOrder(direction, (decimal)Security.GetCurrentPrice(direction), Volume);

                order.WhenNewTrades().Do(ProtectTrades).Apply(this);

				RegisterOrder(order);

				//    
				//var strategy = new MarketQuotingStrategy(direction, Volume);
				//ChildStrategies.Add(strategy);

				//      
				_isShortLessThenLong = isShortLessThenLong;
			}
		}

        private void ProtectTrades(IEnumerable<MyTrade> trades)
        {
           
            foreach (MyTrade t in trades) {

                var stoploss = new StopLossStrategy(t, Security.MinStepSize);
                stoploss.WaitAllTrades = true;
                
                ChildStrategies.Add(stoploss);
            }
        }

	}
}