﻿namespace TestReConnect
{
	using System;
	using System.Linq;
    using System.Threading;
    using System.Net;
    using System.IO;
    using Ecng.Common;
	using StockSharp.BusinessEntities;
	using StockSharp.Smart;
	using StockSharp.Algo;
    using StockSharp.Algo.Logging;

	class Program
	{
		private static Security _security;
		private static Portfolio _portfolio;
 
		static void Main()
		{
			try
			{
				// работаем с фьючерсом на индекс RTS
				const string secCode = "RIZ2";

				///Console.Write("Введите логин: ");
                var login = "BP11111";// Console.ReadLine();
                Console.WriteLine("Логин: {0}", login);

				Console.WriteLine("Пароль: *******");
                var password = "password"; // Console.ReadLine();

				//Console.Write("Введите номер счета, через который будет выставлена заявка: ");
                var account = "BP111111-RF-01";//Console.ReadLine();
                Console.WriteLine("Номер счета: {0}", account);

                var logManager = new LogManager();
                var fileListener = new FileLogListener("{0}_{1:00}_{2:00}.txt".Put(DateTime.Now.Year, DateTime.Now.Month, DateTime.Now.Day));
                logManager.Listeners.Add(fileListener);


				using (var waitHandle = new AutoResetEvent(false))
				{
					// создаем шлюз к Smart-у
                    IPAddress ip;

                    IPAddress.TryParse("95.131.26.244", out ip);
                    //IPAddress.TryParse("82.204.220.34", out ip);
                    SmartTrader trader;

                    using (trader = new SmartTrader(login, password, new IPEndPoint(ip, 8090)))
                    {
                        
                        trader.Connected += () =>
                        {
                            Console.WriteLine("Подключение произведено успешно.");

                            if (_security != null)
                            {
                                trader.RegisterSecurity(_security);
                                trader.RegisterTrades(_security);
                                trader.RegisterMarketDepth(_security);
                            }

                            if (!trader.IsExportStarted)
                            {
                                Console.WriteLine("Запускаем экспорт данных...");
                                trader.StartExport();
                            }

                            // извещаем об успешном соединени
                            waitHandle.Set();
                        };

                        trader.ConnectionError += (Exception ex) =>
                        {
                            Console.WriteLine("Ошибка при подключении:\n {0}", ex);
                            Console.ReadLine();
                            return;
                        };

                        trader.Disconnected += () =>
                        {
                            Console.WriteLine("Трейдер отключен.");
                        };

                        Console.WriteLine("Производим подключение...");

                        // настраиваем переподключение при обрыве связи для SmartCom  
                        trader.ReConnectionSettings.ReConnectingAttemptCount = -1;
                        trader.ReConnectionSettings.ConnectingAttemptCount = -1;
                        trader.ReConnectionSettings.IsReStartExport = false;
                        trader.ReConnectionSettings.ExportTimeOutInterval = TimeSpan.FromSeconds(30);
                        trader.ReConnectionSettings.Interval = TimeSpan.FromSeconds(10);
                        trader.ReConnectionSettings.WorkingTime = Exchange.Rts.WorkingTime;
                        trader.ReConnectionSettings.ConnectionRestored += () =>
                        {
                            Console.WriteLine("Соединение восстановлено.");
                        };

                        trader.Connect();

                        // дожидаемся события об успешном соединении
                        waitHandle.WaitOne();

                        // подписываемся на все портфели-счета
                        trader.NewPortfolios += portfolios =>
                        {
                            if (_portfolio == null)
                            {
                                // находим нужный портфель и присваиваем его переменной _portfolio
                                _portfolio = portfolios.FirstOrDefault(p => p.Name == account);

                                if (_portfolio != null)
                                {
                                    Console.WriteLine("Портфель {0} появился.", account);

                                    trader.RegisterPortfolio(_portfolio);

                                    if (_security != null)
                                        waitHandle.Set();
                                }
                            }
                        };

                        // подписываемся на событие появления инструментов
                        trader.NewSecurities += securities =>
                        {
                            if (_security == null)
                            {
                                _security = securities.FirstOrDefault(sec => sec.Code == secCode && sec.Type == SecurityTypes.Future);

                                if (_security != null)
                                {
                                    Console.WriteLine("Инструмент {0} появился.", secCode);

                                    if (_portfolio != null)
                                        waitHandle.Set();
                                }
                            }
                        };

                        trader.NewTrades += t =>
                        {
                            Console.WriteLine("OnNewTrades has been fired.");
                        };
                        
                        Console.WriteLine("Дожидаемся появления в программе инструмента {0} и портфеля {1}...", secCode, account);

                        // запускаем экспорт по инструментам и портфелям
//                        trader.StartExport();

                        // дожидаемся появления портфеля и инструмента
                        waitHandle.WaitOne();

                        Console.WriteLine("Получаем данные по инструменту {0}...", secCode);

                        // запускаем обновление по инструменту
                        trader.RegisterSecurity(_security);
                        trader.RegisterTrades(_security);
                        trader.RegisterMarketDepth(_security);

                        while (true) {
                            
                            Console.Write("#> ");
                            string command = Console.ReadLine();
                            if (command.Equals("exit"))
                            {
                                break;
                            } else if (command.Equals("disconnect"))
                            {
                                trader.Disconnect();
                            }
                            else if (command.Equals("connect"))
                            {
                                trader.Connect();
                            }

                        }

                        // останавливаем экспорт
                        trader.StopExport();
                        trader.UnRegisterMarketDepth(_security);
                        trader.UnRegisterPortfolio(_portfolio);
                        trader.UnRegisterSecurity(_security);
                        trader.UnRegisterTrades(_security);
                        trader.Disconnect();
                    }
				}
			}
			catch (Exception ex)
			{
				Console.WriteLine(ex);
			}
		}
	}
}